import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class Dango {

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);

        int n = in.nextInt();
        int m = in.nextInt();

        Dishes dishes = new Dishes(in.next().toCharArray());

        List<Order> orders = new ArrayList<>(m);
        for (int i = 0; i < m; i++) {
            orders.add(new Order(in.nextInt(), in.next(".").charAt(0), in.next(".").charAt(0)));
        }

        for (Order order : orders) {
            dishes.replace(order.dish, order.newDish, order.amount);
            System.out.println(dishes);
        }

        System.out.println("");
        System.out.println(dishes);
    }

    static class Order {
        final int amount;
        final char dish;
        final char newDish;

        Order(int amount, char dish, char newDish) {
            this.amount = amount;
            this.dish = dish;
            this.newDish = newDish;
        }
    }

    static class Dishes {
        final char[] array;

        Dishes(char[] array) {
            this.array = array;
        }

        void replace(char oldDish, char newDish, int amount) {
            int count = 0;
            for (int i = 0; i < array.length && count < amount; i++) {
                if (array[i] == oldDish){
                    array[i] = newDish;
                    count++;
                }
            }
        }

        @Override
        public String toString() {
            return new String(array);
        }
    }
}
